---
category: overview
heading: "Why not just use an iframe?"
---

Third-party content is often distributed in iframes. Because JavaScript within an iframe can be prevented from accessing the host page, iframes are particularly useful when the host site has security concerns and does not explicitly trust the third-party content.

However, iframes have some drawbacks:
* You cannot display content outside of the box of the iframe
* It is tricky to resize the iframe to match the size of its contents
* Your content will be unable to interact with the host page, even if it is trusted
* Search engines like Google will not see the content on the host page. Content that is syndicated from a partner website can avoid this by being directly included in the host page.


Iframe-based resetting for distributed content
----------------------------------------------

Cleanslate only resets CSS styles. But if you also need to protect your content from JavaScript on the host page, then see ["AppleOfMyIframe"](https://github.com/premasagar/appleofmyiframe)', which allows you to inject HTML into a "sourceless" iframe element that the browser treats as being on the same domain as the host.

If your host page needs to isolate and sandbox third-party JavaScript, then you might want to use ["Sandie"](https://github.com/premasagar/sandie).
